<?php
$jsonFile = "autoreplies.json";
$messagesFile = "messages.json";

$autoReplies = file_exists($jsonFile) ? json_decode(file_get_contents($jsonFile), true) : [];
$messages = file_exists($messagesFile) ? json_decode(file_get_contents($messagesFile), true) : [];

// Auto reply add
if(isset($_POST['keyword']) && isset($_POST['reply'])){
    $autoReplies[$_POST['keyword']] = $_POST['reply'];
    file_put_contents($jsonFile, json_encode($autoReplies, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
    header("Location: panel.php");
    exit;
}

// Auto reply delete
if(isset($_GET['delete'])){
    unset($autoReplies[$_GET['delete']]);
    file_put_contents($jsonFile, json_encode($autoReplies, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
    header("Location: panel.php");
    exit;
}

// Manual reply
if(isset($_POST['manual_chat_id']) && isset($_POST['manual_reply'])){
    $chat_id = $_POST['manual_chat_id'];
    $reply = $_POST['manual_reply'];

    $TOKEN = "YOUR_BOT_TOKEN";
    $API_URL = "https://api.telegram.org/bot$TOKEN/";
    file_get_contents($API_URL."sendMessage?chat_id=$chat_id&text=".urlencode($reply));

    // মেসেজ আপডেট করে লগে রাখি
    $messages[] = [
        "chat_id" => $chat_id,
        "username" => "ADMIN",
        "text" => $reply,
        "reply" => "(Manual)"
    ];
    file_put_contents($messagesFile, json_encode($messages, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));

    header("Location: panel.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Bot Control Panel</title>
<style>
body{font-family:Arial;margin:20px;}
table{border-collapse:collapse;width:90%;}
td,th{border:1px solid #ccc;padding:8px;}
form{margin-top:20px;}
.chat-box{border:1px solid #aaa;margin:10px;padding:10px;}
</style>
</head>
<body>
<h2>🤖 Auto Reply Manager</h2>
<table>
<tr><th>Keyword</th><th>Reply</th><th>Action</th></tr>
<?php foreach($autoReplies as $k=>$v): ?>
<tr>
  <td><?=htmlspecialchars($k)?></td>
  <td><?=htmlspecialchars($v)?></td>
  <td><a href="?delete=<?=urlencode($k)?>" onclick="return confirm('Delete this?')">❌ Delete</a></td>
</tr>
<?php endforeach; ?>
</table>

<h3>Add New Auto Reply</h3>
<form method="POST">
  Keyword: <input type="text" name="keyword" required>
  Reply: <input type="text" name="reply" required>
  <button type="submit">Add</button>
</form>

<hr>

<h2>📩 Chat Inbox</h2>
<?php foreach(array_reverse($messages) as $msg): ?>
<div class="chat-box">
  <b><?=htmlspecialchars($msg['username'])?></b>: <?=htmlspecialchars($msg['text'])?><br>
  <i>Bot Reply:</i> <?=htmlspecialchars($msg['reply'])?><br><br>

  <form method="POST">
    <input type="hidden" name="manual_chat_id" value="<?=$msg['chat_id']?>">
    <input type="text" name="manual_reply" placeholder="Type manual reply...">
    <button type="submit">Send</button>
  </form>
</div>
<?php endforeach; ?>
</body>
</html>